﻿//***************************************************************************************
// HillsDemo.cpp Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//
// Wykonuje obliczenia do symulacji fali. Po aktualizacji symulacji klientu musi skopiować
// bieżące rozwiązanie do buforów wierzchoĹ‚ków w celu jego wyrenderowania.
// Ta klasa odpowiada tylko za obliczenia. Renderowanie odbywa się gdzie inidziej.
//***************************************************************************************

#ifndef WAVES_H
#define WAVES_H

#include <Windows.h>
#include <xnamath.h>

class Waves
{
public:
	Waves();
	~Waves();

	UINT RowCount()const;
	UINT ColumnCount()const;
	UINT VertexCount()const;
	UINT TriangleCount()const;

	// Zwraca rozwiązanie w i-tym punkcie siatki.
	const XMFLOAT3& operator[](int i)const { return mCurrSolution[i]; }

	void Init(UINT m, UINT n, float dx, float dt, float speed, float damping);
	void Update(float dt);
	void Disturb(UINT i, UINT j, float magnitude);

private:
	UINT mNumRows;
	UINT mNumCols;

	UINT mVertexCount;
	UINT mTriangleCount;

	// StaĹ‚e symulacji
	// 
	float mK1;
	float mK2;
	float mK3;

	float mTimeStep;
	float mSpatialStep;

	XMFLOAT3* mPrevSolution;
	XMFLOAT3* mCurrSolution;
};

#endif // WAVES_H